\version "2.16.0"

\paper {
 %#(set-paper-size "a4")
  between-system-padding = 0\mm
  markup-system-spacing = #'((basic-distance . 2))
  %system-system-spacing = #'((basic-distance . 1))
  %system-system-spacing #'basic-distance = #1
  left-margin = 1.5\cm
  line-width = 19.4\cm
  print-page-number = false
  top-margin = 5\mm
  bottom-margin = 5\mm
  ragged-last-bottom=##f
  system-count = #5
}

% diacritice: ă â î ş ţ Ţ Ş Ă Î

\header {
  title = "Imnul mirilor"
  subtitle = "Vino din Liban, mireasă"
  composer =  \markup \center-column { "Gavriil Musicescu" \small 
  "(1847 – 1903)" }
  %meter = "Lento"
  tagline=""
}

global = {
  \key bes \major
  \autoBeamOff
  \time 4/4
  %\partial 4
  \set Staff.midiInstrument = "clarinet"
}

womenWords = \lyricmode {
  Vi -- no, vi -- no din Li -- ban __ mi -- rea -- să,
  Vi -- no, vi -- no din Li -- ban __ mi -- rea -- să.
  Vi -- no, vi -- no, bu -- na mea;
  Vi -- no, vi -- no, de a -- proa -- pea mea;
  Vi -- no, po -- rum -- bi -- ţa mea.
  A -- ra -- tă-mi, a -- ra -- tă-mi fa -- ţa ta 
  şi mă fă să a -- ud gla -- sul tău;
  gla -- sul tău, gla -- sul tău e dul -- ce şi
  fa -- ţa ta şi fa -- ţa ta-i fru -- moa -- să.
}

menWords = \lyricmode {
  
}

sopMusic = \relative c'' {
  d4.^\mf c8 d d d ees f8.([ g16 f8]) ees ees d b4\rest
  c4. c8 c c a bes c8.([ d16 ees8]) c d d b4\rest
  g'2^\f f ees d f8.^\p([ ees16]) d8([ c]) d2
  g2^\f f ees d f8 ees d c d2 e f4 f8 f f4 e f b,8\rest
  c8^\p c4.( a8) c4. f8 f([ e]) d([ c]) c bes bes4 
  bes4. g8 bes4.( d8) d c c([ bes]) bes8. a16 a4
  e'4.^\f e8 f2 f8. f16 f8 f e4 f8 f
  e4. e8 f4. f8 f4. f8 f4 f f( e) f2	
  \fermata
  \bar "|."
}

altMusic = \relative c'' {
  bes4. a8 bes bes bes c d8.([ ees16 d8]) c c bes b4\rest
  a4. g8 a a f g a8.([ bes16 c8]) c bes bes b4\rest
  ees2 d c bes d8.([ c16]) bes8([ a]) bes2
  ees d c bes d8 c bes a bes2 c c4 d8 d c4 bes a b8\rest
  a8 a4.( f8) a4. a8 a([ c]) bes([ a]) a g g4 
  g4. ees8 g4.( bes8) bes a a([ g]) g8. f16 f4
  c'4. c8 c2 d8. d16 c8 c c4 c8 c
  c4. c8 c4. c8 d4. d8 c4 c bes2 a  
}

tenorMusic = \relative {
  bes4. f8 f f d4\rest d1\rest
  f4. e8 f f f f f4. f8 bes bes, d4\rest
  bes'2 bes a f f4 f f2
  bes bes a f f8 f f f f2 g f4 bes8 bes a4 g f d8\rest
  f8 f2 f4. f8 f4 f fis8 g c,4 c4. c8 c2 c8 c c4 e8. f16 f4
  g4. g8 f2 bes8. bes16 a8 a g4 a8 a
  g4. g8 a4. a8 bes4. bes8 a4 a g2 f
}

bassMusic = \relative {
  bes4. f8 bes, bes d4\rest d1\rest
  f4. c8 f f f f f4. f8 bes bes, d4\rest
  ees8.([ f16 g8 ees]) bes'2 f bes, f'4 f bes,2
  ees8.([ f16 g8 ees]) bes'2 f bes, f'8 f f f bes,2 g' f4 bes,8 bes c4 c f d8\rest
  f8 f2 f4. f8 f4 f fis8 g c,4 c4. c8 c2 c8 c c4 e8. f16 f4
  g4. g8 f2 bes8. bes16 c8 c c,4 f8 f
  c4. c8 f4. f8 bes,4. bes8 c4 c c2 f,
}

myScore = \new Score <<
  \new ChoirStaff <<
    \new Staff <<
      \new Voice { \global \voiceOne \sopMusic }
      \new Voice { \global \voiceTwo \altMusic }
      \addlyrics { \womenWords }
    >>
    \new Staff <<
      \clef bass
      \new Voice { \global \voiceOne \tenorMusic }
      \new Voice { \global \voiceTwo \bassMusic }
      \addlyrics { \menWords }
    >>
    >>
>>

\score {
  \myScore
  \layout { }
}

midiOutput = \midi {
    \tempo 4 = 40
    \context { \Voice \remove "Dynamic_performer" }
}

\score {
  \myScore
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \sopMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \altMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \tenorMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \bassMusic }
  \midi { \midiOutput }
}
